
' MODULE:  WIN31API.BAS
'
' PURPOSE: Selected general Windows 3.1 API definitions and declarations
'
' AUTHOR:  Graham Plowman
'
' DATE:    23/11/95

Option Explicit

' Set system colours...
Declare Function GetSysColor& Lib "User" (ByVal nIndex%)
Declare Sub SetSysColors Lib "User" (ByVal nChanges%, lpSysColor%, lpColorValues&)

' Loader Routines
Declare Function GetModuleHandle Lib "Kernel" (ByVal lpModuleName As String) As Integer
Declare Function GetModuleUsage Lib "Kernel" (ByVal hModule As Integer) As Integer
Declare Function GetModuleFileName Lib "Kernel" (ByVal hModule As Integer, ByVal lpFilename As String, ByVal nSize As Integer) As Integer
Declare Function GetFreeSpace Lib "Kernel" (ByVal wFlags As Integer) As Long
Declare Function WinExec Lib "Kernel" (ByVal lpCmdLine As String, ByVal nCmdShow As Integer) As Integer
Declare Function GetVersion Lib "Kernel" () As Long

Declare Function GetTempDrive Lib "Kernel" (ByVal cDriveLetter As Integer) As Integer
Declare Function GetTempFileName Lib "Kernel" (ByVal cDriveLetter As Integer, ByVal lpPrefixString As String, ByVal wUnique As Integer, ByVal lpTempFileName As String) As Integer

Declare Function GetDriveType Lib "Kernel" (ByVal nDrive As Integer) As Integer

' GetDriveType return values
Global Const DRIVE_REMOVABLE = 2
Global Const DRIVE_FIXED = 3
Global Const DRIVE_REMOTE = 4


Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

' Language dependent Routines
Declare Function IsCharAlpha Lib "User" (ByVal cChar As Integer) As Integer
Declare Function IsCharAlphaNumeric Lib "User" (ByVal cChar As Integer) As Integer
Declare Function IsCharUpper Lib "User" (ByVal cChar As Integer) As Integer
Declare Function IsCharLower Lib "User" (ByVal cChar As Integer) As Integer

Declare Function GetWinFlags Lib "Kernel" () As Long

Global Const WF_PMODE = &H1
Global Const WF_CPU286 = &H2
Global Const WF_CPU386 = &H4
Global Const WF_CPU486 = &H8
Global Const WF_STANDARD = &H10
Global Const WF_WIN286 = &H10
Global Const WF_ENHANCED = &H20
Global Const WF_WIN386 = &H20
Global Const WF_CPU086 = &H40
Global Const WF_CPU186 = &H80
Global Const WF_LARGEFRAME = &H100
Global Const WF_SMALLFRAME = &H200
Global Const WF_80x87 = &H400
Global Const WF_WINNT = &H4000

' ShowWindow() Commands
Global Const SW_HIDE = 0
Global Const SW_SHOWNORMAL = 1
Global Const SW_NORMAL = 1
Global Const SW_SHOWMINIMIZED = 2
Global Const SW_SHOWMAXIMIZED = 3
Global Const SW_MAXIMIZE = 3
Global Const SW_SHOWNOACTIVATE = 4
Global Const SW_SHOW = 5
Global Const SW_MINIMIZE = 6
Global Const SW_SHOWMINNOACTIVE = 7
Global Const SW_SHOWNA = 8
Global Const SW_RESTORE = 9

' Window field offsets for GetWindowLong() and GetWindowWord()
Global Const GWL_WNDPROC = (-4)
Global Const GWW_HINSTANCE = (-6)
Global Const GWW_HWNDPARENT = (-8)
Global Const GWW_ID = (-12)
Global Const GWL_STYLE = (-16)
Global Const GWL_EXSTYLE = (-20)

' Message structures
Type POINTAPI
    x As Integer
    y As Integer
End Type

Type MSG
    hWnd As Integer
    message As Integer
    wParam As Integer
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

' Window Messages
Global Const WM_NULL = &H0
Global Const WM_CREATE = &H1
Global Const WM_DESTROY = &H2
Global Const WM_MOVE = &H3
Global Const WM_SIZE = &H5
Global Const WM_ACTIVATE = &H6
Global Const WM_SETFOCUS = &H7
Global Const WM_KILLFOCUS = &H8
Global Const WM_ENABLE = &HA
Global Const WM_SETREDRAW = &HB
Global Const WM_SETTEXT = &HC
Global Const WM_GETTEXT = &HD
Global Const WM_GETTEXTLENGTH = &HE
Global Const WM_PAINT = &HF
Global Const WM_CLOSE = &H10
Global Const WM_QUERYENDSESSION = &H11
Global Const WM_QUIT = &H12
Global Const WM_QUERYOPEN = &H13
Global Const WM_ERASEBKGND = &H14
Global Const WM_SYSCOLORCHANGE = &H15
Global Const WM_ENDSESSION = &H16
Global Const WM_SHOWWINDOW = &H18
Global Const WM_CTLCOLOR = &H19
Global Const WM_WININICHANGE = &H1A
Global Const WM_DEVMODECHANGE = &H1B
Global Const WM_ACTIVATEAPP = &H1C
Global Const WM_FONTCHANGE = &H1D
Global Const WM_TIMECHANGE = &H1E
Global Const WM_CANCELMODE = &H1F
Global Const WM_SETCURSOR = &H20
Global Const WM_MOUSEACTIVATE = &H21
Global Const WM_CHILDACTIVATE = &H22
Global Const WM_QUEUESYNC = &H23
Global Const WM_GETMINMAXINFO = &H24
Global Const WM_PAINTICON = &H26
Global Const WM_ICONERASEBKGND = &H27
Global Const WM_NEXTDLGCTL = &H28
Global Const WM_SPOOLERSTATUS = &H2A
Global Const WM_DRAWITEM = &H2B
Global Const WM_MEASUREITEM = &H2C
Global Const WM_DELETEITEM = &H2D
Global Const WM_VKEYTOITEM = &H2E
Global Const WM_CHARTOITEM = &H2F
Global Const WM_SETFONT = &H30
Global Const WM_GETFONT = &H31

Global Const WM_QUERYDRAGICON = &H37

Global Const WM_COMPAREITEM = &H39
Global Const WM_COMPACTING = &H41

Global Const WM_NCCREATE = &H81
Global Const WM_NCDESTROY = &H82
Global Const WM_NCCALCSIZE = &H83
Global Const WM_NCHITTEST = &H84
Global Const WM_NCPAINT = &H85
Global Const WM_NCACTIVATE = &H86
Global Const WM_GETDLGCODE = &H87
Global Const WM_NCMOUSEMOVE = &HA0
Global Const WM_NCLBUTTONDOWN = &HA1
Global Const WM_NCLBUTTONUP = &HA2
Global Const WM_NCLBUTTONDBLCLK = &HA3
Global Const WM_NCRBUTTONDOWN = &HA4
Global Const WM_NCRBUTTONUP = &HA5
Global Const WM_NCRBUTTONDBLCLK = &HA6
Global Const WM_NCMBUTTONDOWN = &HA7
Global Const WM_NCMBUTTONUP = &HA8
Global Const WM_NCMBUTTONDBLCLK = &HA9

Global Const WM_KEYFIRST = &H100
Global Const WM_KEYDOWN = &H100
Global Const WM_KEYUP = &H101
Global Const WM_CHAR = &H102
Global Const WM_DEADCHAR = &H103
Global Const WM_SYSKEYDOWN = &H104
Global Const WM_SYSKEYUP = &H105
Global Const WM_SYSCHAR = &H106
Global Const WM_SYSDEADCHAR = &H107
Global Const WM_KEYLAST = &H108

Global Const WM_INITDIALOG = &H110
Global Const WM_COMMAND = &H111
Global Const WM_SYSCOMMAND = &H112
Global Const WM_TIMER = &H113
Global Const WM_HSCROLL = &H114
Global Const WM_VSCROLL = &H115
Global Const WM_INITMENU = &H116
Global Const WM_INITMENUPOPUP = &H117
Global Const WM_MENUSELECT = &H11F
Global Const WM_MENUCHAR = &H120
Global Const WM_ENTERIDLE = &H121

Global Const WM_MOUSEFIRST = &H200
Global Const WM_MOUSEMOVE = &H200
Global Const WM_LBUTTONDOWN = &H201
Global Const WM_LBUTTONUP = &H202
Global Const WM_LBUTTONDBLCLK = &H203
Global Const WM_RBUTTONDOWN = &H204
Global Const WM_RBUTTONUP = &H205
Global Const WM_RBUTTONDBLCLK = &H206
Global Const WM_MBUTTONDOWN = &H207
Global Const WM_MBUTTONUP = &H208
Global Const WM_MBUTTONDBLCLK = &H209
Global Const WM_MOUSELAST = &H209

Global Const WM_PARENTNOTIFY = &H210
Global Const WM_MDICREATE = &H220
Global Const WM_MDIDESTROY = &H221
Global Const WM_MDIACTIVATE = &H222
Global Const WM_MDIRESTORE = &H223
Global Const WM_MDINEXT = &H224
Global Const WM_MDIMAXIMIZE = &H225
Global Const WM_MDITILE = &H226
Global Const WM_MDICASCADE = &H227
Global Const WM_MDIICONARRANGE = &H228
Global Const WM_MDIGETACTIVE = &H229
Global Const WM_MDISETMENU = &H230

Global Const WM_CUT = &H300
Global Const WM_COPY = &H301
Global Const WM_PASTE = &H302
Global Const WM_CLEAR = &H303
Global Const WM_UNDO = &H304
Global Const WM_RENDERFORMAT = &H305
Global Const WM_RENDERALLFORMATS = &H306
Global Const WM_DESTROYCLIPBOARD = &H307
Global Const WM_DRAWCLIPBOARD = &H308
Global Const WM_PAINTCLIPBOARD = &H309
Global Const WM_VSCROLLCLIPBOARD = &H30A
Global Const WM_SIZECLIPBOARD = &H30B
Global Const WM_ASKCBFORMATNAME = &H30C
Global Const WM_CHANGECBCHAIN = &H30D
Global Const WM_HSCROLLCLIPBOARD = &H30E
Global Const WM_QUERYNEWPALETTE = &H30F
Global Const WM_PALETTEISCHANGING = &H310
Global Const WM_PALETTECHANGED = &H311

' NOTE: All Message Numbers below 0x0400 are RESERVED.

' Private Window Messages Start Here:
Global Const WM_USER = &H400

' Predefined Clipboard Formats
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILE = 3
Global Const CF_DIB = 8
Global Const CF_PALETTE = 9

' Message Function Templates
Declare Function GetMessage Lib "User" (lpMsg As MSG, ByVal hWnd As Integer, ByVal wMsgFilterMin As Integer, ByVal wMsgFilterMax As Integer) As Integer
Declare Function TranslateMessage Lib "User" (lpMsg As MSG) As Integer
Declare Function DispatchMessage Lib "User" (lpMsg As MSG) As Long
Declare Function PeekMessage Lib "User" (lpMsg As MSG, ByVal hWnd As Integer, ByVal wMsgFilterMin As Integer, ByVal wMsgFilterMax As Integer, ByVal wRemoveMsg As Integer) As Integer

' PeekMessage() Options
Global Const PM_NOREMOVE = &H0
Global Const PM_REMOVE = &H1
Global Const PM_NOYIELD = &H2

' File handling
Declare Function lopen Lib "Kernel" Alias "_lopen" (ByVal lpPathName As String, ByVal iReadWrite As Integer) As Integer
Declare Function lclose Lib "Kernel" Alias "_lclose" (ByVal hFile As Integer) As Integer
Declare Function lcreat Lib "Kernel" Alias "_lcreat" (ByVal lpPathName As String, ByVal iAttribute As Integer) As Integer
Declare Function llseek Lib "Kernel" Alias "_llseek" (ByVal hFile As Integer, ByVal lOffset As Long, ByVal iOrigin As Integer) As Long
Declare Function lread Lib "Kernel" Alias "_lread" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal wBytes As Integer) As Integer
Declare Function lwrite Lib "Kernel" Alias "_lwrite" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal wBytes As Integer) As Integer

Global Const READAPI = 0        '  Flags for _lopen
Global Const WRITEAPI = 1
Global Const READ_WRITE = 2


Declare Function ExitWindows Lib "User" (ByVal dwReturnCode As Long, ByVal wReserved As Integer) As Integer

Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function PostMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Integer
Declare Function PostAppMessage Lib "User" (ByVal hTask As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Integer

Declare Function IsWindow Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function IsChild Lib "User" (ByVal hWndParent As Integer, ByVal hWnd As Integer) As Integer

Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
Declare Function FlashWindow Lib "User" (ByVal hWnd As Integer, ByVal bInvert As Integer) As Integer

Declare Sub MoveWindow Lib "User" (ByVal hWnd As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal bRepaint As Integer)

Declare Function IsWindowVisible Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function IsIconic Lib "User" (ByVal hWnd As Integer) As Integer
Declare Sub BringWindowToTop Lib "User" (ByVal hWnd As Integer)
Declare Function IsZoomed Lib "User" (ByVal hWnd As Integer) As Integer

Declare Sub UpdateWindow Lib "User" (ByVal hWnd As Integer)

Declare Function SetFocusAPI Lib "User" Alias "SetFocus" (ByVal hWnd As Integer) As Integer
Declare Function GetFocus Lib "User" () As Integer
Declare Function GetActiveWindow Lib "User" () As Integer
Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function GetAsyncKeyState Lib "User" (ByVal vKey As Integer) As Integer
Declare Sub GetKeyboardState Lib "User" (lpKeyState As Any)
Declare Sub SetKeyboardState Lib "User" (lpKeyState As Any)

' Menu flags for Add/Check/EnableMenuItem()
Global Const MF_INSERT = &H0
Global Const MF_CHANGE = &H80
Global Const MF_APPEND = &H100
Global Const MF_DELETE = &H200
Global Const MF_REMOVE = &H1000

Global Const MF_BYCOMMAND = &H0
Global Const MF_BYPOSITION = &H400

Global Const MF_SEPARATOR = &H800

Global Const MF_ENABLED = &H0
Global Const MF_GRAYED = &H1
Global Const MF_DISABLED = &H2

Global Const MF_UNCHECKED = &H0
Global Const MF_CHECKED = &H8
Global Const MF_USECHECKBITMAPS = &H200

Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function DeleteMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function GetMenu Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function SetMenu Lib "User" (ByVal hWnd As Integer, ByVal hMenu As Integer) As Integer
Declare Function ChangeMenu Lib "User" (ByVal hMenu As Integer, ByVal wID As Integer, ByVal lpszNew As String, ByVal wIDNew As Integer, ByVal wChange As Integer) As Integer
Declare Function HiliteMenuItem Lib "User" (ByVal hWnd As Integer, ByVal hMenu As Integer, ByVal wIDHiliteItem As Integer, ByVal wHilite As Integer) As Integer
Declare Sub DrawMenuBar Lib "User" (ByVal hWnd As Integer)
Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function CreateMenu Lib "User" () As Integer
Declare Function CreatePopupMenu Lib "User" () As Integer
Declare Function DestroyMenu Lib "User" (ByVal hMenu As Integer) As Integer
Declare Function CheckMenuItem Lib "User" (ByVal hMenu As Integer, ByVal wIDCheckItem As Integer, ByVal wCheck As Integer) As Integer
Declare Function EnableMenuItem Lib "User" (ByVal hMenu As Integer, ByVal wIDEnableItem As Integer, ByVal wEnable As Integer) As Integer
Declare Function GetSubMenu Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function GetMenuItemID Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function GetMenuItemCount Lib "User" (ByVal hMenu As Integer) As Integer

Declare Function InsertMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function AppendMenu Lib "User" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
Declare Function ModifyMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpString As Any) As Integer
Declare Function RemoveMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function DeleteMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer

' MessageBox() Flags
Global Const MB_OK = &H0
Global Const MB_OKCANCEL = &H1
Global Const MB_ABORTRETRYIGNORE = &H2
Global Const MB_YESNOCANCEL = &H3
Global Const MB_YESNO = &H4
Global Const MB_RETRYCANCEL = &H5

Global Const MB_ICONHAND = &H10
Global Const MB_ICONQUESTION = &H20
Global Const MB_ICONEXCLAMATION = &H30
Global Const MB_ICONASTERISK = &H40

Global Const MB_ICONINFORMATION = MB_ICONASTERISK
Global Const MB_ICONSTOP = MB_ICONHAND

Global Const MB_DEFBUTTON1 = &H0
Global Const MB_DEFBUTTON2 = &H100
Global Const MB_DEFBUTTON3 = &H200

Global Const MB_APPLMODAL = &H0
Global Const MB_SYSTEMMODAL = &H1000
Global Const MB_TASKMODAL = &H2000

Global Const MB_NOFOCUS = &H8000

Global Const MB_TYPEMASK = &HF
Global Const MB_ICONMASK = &HF0
Global Const MB_DEFMASK = &HF00
Global Const MB_MODEMASK = &H3000
Global Const MB_MISCMASK = &HC000

Declare Sub MessageBeep Lib "User" (ByVal wType As Integer)

Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Sub SetSysColors Lib "User" (ByVal nChanges As Integer, lpSysColor As Integer, lpColorValues As Long)

Declare Function GetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function SetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal wNewWord As Integer) As Integer
Declare Function GetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long
Declare Function SetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Long) As Long
Declare Function GetClassWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function SetClassWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal wNewWord As Integer) As Integer
Declare Function GetClassLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long
Declare Function SetClassLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Long) As Long
Declare Function GetDesktopHwnd Lib "User" () As Integer
Declare Function GetDesktopWindow Lib "User" () As Integer


Declare Function GetParent Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function SetParent Lib "User" (ByVal hWndChild As Integer, ByVal hWndNewParent As Integer) As Integer
Declare Function FindWindow Lib "User" (ByVal lpClassName As Any, ByVal lpWindowName As Any) As Integer
Declare Function GetTopWindow Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function GetNextWindow Lib "User" (ByVal hWnd As Integer, ByVal wFlag As Integer) As Integer
Declare Function GetLastActivePopup Lib "User" (ByVal hwndOwnder As Integer) As Integer

' GetWindow() Constants
Global Const GW_HWNDFIRST = 0
Global Const GW_HWNDLAST = 1
Global Const GW_HWNDNEXT = 2
Global Const GW_HWNDPREV = 3
Global Const GW_OWNER = 4
Global Const GW_CHILD = 5

Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer

'Windows API constants for message boxes, mouse
'pointers:
Global Const CURSORDEFAULT = 0      ' (Default) Shape determined by the control
Global Const CURSORARROW = 1        ' Arrow
Global Const CURSORCROSS = 2        ' Cross (cross-hair pointer)
Global Const CURSORIBEAM = 3        ' I-Beam
Global Const CURSORICON = 4         ' Icon (small square within a square)
Global Const CURSORNSEW = 5         ' Size (four-pointed arrow pointing north, south, east, west)
Global Const CURSORNESW = 6         ' Size NE SW (double arrow pointing northeast and southwest)
Global Const CURSORNS = 7           ' Size N S (double arrow pointing north and south)
Global Const CURSORNWSE = 8         ' Size NW SE (double arrow pointing northwest and southeast)
Global Const CURSORWE = 9           ' Size W E (double arrow pointing west and east)
Global Const CURSORUPARROW = 10     ' Up Arrow
Global Const CURSORHOURGLASS = 11   ' Hourglass (wait)
Global Const CURSORNODROP = 12      ' No Drop

' Dialog Box Command IDs
Global Const IDOK = 1
Global Const IDCANCEL = 2
Global Const IDABORT = 3
Global Const IDRETRY = 4
Global Const IDIGNORE = 5
Global Const IDYES = 6
Global Const IDNO = 7

' Edit Control Messages
Global Const EM_GETSEL = WM_USER + 0
Global Const EM_SETSEL = WM_USER + 1
Global Const EM_SCROLL = WM_USER + 5
Global Const EM_LINESCROLL = WM_USER + 6
Global Const EM_GETMODIFY = WM_USER + 8
Global Const EM_SETMODIFY = WM_USER + 9
Global Const EM_GETLINECOUNT = WM_USER + 10
Global Const EM_LINEINDEX = WM_USER + 11
Global Const EM_LINELENGTH = WM_USER + 17
Global Const EM_REPLACESEL = WM_USER + 18
Global Const EM_GETLINE = WM_USER + 20
Global Const EM_LIMITTEXT = WM_USER + 21
Global Const EM_CANUNDO = WM_USER + 22
Global Const EM_UNDO = WM_USER + 23
Global Const EM_FMTLINES = WM_USER + 24
Global Const EM_LINEFROMCHAR = WM_USER + 25
Global Const EM_SETWORDBREAK = WM_USER + 26
Global Const EM_SETTABSTOPS = WM_USER + 27
Global Const EM_SETPASSWORDCHAR = WM_USER + 28
Global Const EM_EMPTYUNDOBUFFER = WM_USER + 29
Global Const EM_MSGMAX = WM_USER + 30
Global Const EM_SETREADONLY = (WM_USER + 31)

' Listbox Return Values
Global Const LB_OKAY = 0
Global Const LB_ERR = (-1)
Global Const LB_ERRSPACE = (-2)

' Listbox messages
Global Const LB_ADDSTRING = (WM_USER + 1)
Global Const LB_INSERTSTRING = (WM_USER + 2)
Global Const LB_DELETESTRING = (WM_USER + 3)
Global Const LB_RESETCONTENT = (WM_USER + 5)
Global Const LB_SETSEL = (WM_USER + 6)
Global Const LB_SETCURSEL = (WM_USER + 7)
Global Const LB_GETSEL = (WM_USER + 8)
Global Const LB_GETCURSEL = (WM_USER + 9)
Global Const LB_GETTEXT = (WM_USER + 10)
Global Const LB_GETTEXTLEN = (WM_USER + 11)
Global Const LB_GETCOUNT = (WM_USER + 12)
Global Const LB_SELECTSTRING = (WM_USER + 13)
Global Const LB_DIR = (WM_USER + 14)
Global Const LB_GETTOPINDEX = (WM_USER + 15)
Global Const LB_FINDSTRING = (WM_USER + 16)
Global Const LB_GETSELCOUNT = (WM_USER + 17)
Global Const LB_GETSELITEMS = (WM_USER + 18)
Global Const LB_SETTABSTOPS = (WM_USER + 19)
Global Const LB_GETHORIZONTALEXTENT = (WM_USER + 20)
Global Const LB_SETHORIZONTALEXTENT = (WM_USER + 21)
Global Const LB_SETCOLUMNWIDTH = (WM_USER + 22)
Global Const LB_SETTOPINDEX = (WM_USER + 24)
Global Const LB_GETITEMRECT = (WM_USER + 25)
Global Const LB_GETITEMDATA = (WM_USER + 26)
Global Const LB_SETITEMDATA = (WM_USER + 27)
Global Const LB_SELITEMRANGE = (WM_USER + 28)
Global Const LB_MSGMAX = (WM_USER + 33)

' Combo Box return Values
Global Const CB_OKAY = 0
Global Const CB_ERR = (-1)
Global Const CB_ERRSPACE = (-2)

' Combo Box messages
Global Const CB_GETEDITSEL = (WM_USER + 0)
Global Const CB_LIMITTEXT = (WM_USER + 1)
Global Const CB_SETEDITSEL = (WM_USER + 2)
Global Const CB_DIR = (WM_USER + 5)
Global Const CB_GETCOUNT = (WM_USER + 6)
Global Const CB_GETCURSEL = (WM_USER + 7)
Global Const CB_GETLBTEXT = (WM_USER + 8)
Global Const CB_GETLBTEXTLEN = (WM_USER + 9)
Global Const CB_FINDSTRING = (WM_USER + 12)
Global Const CB_SELECTSTRING = (WM_USER + 13)
Global Const CB_SETCURSEL = (WM_USER + 14)
Global Const CB_SHOWDROPDOWN = (WM_USER + 15)
Global Const CB_MSGMAX = (WM_USER + 19)

Declare Function Escape Lib "GDI" (ByVal hDC As Integer, ByVal nEscape As Integer, ByVal nCount As Integer, lplnData As Any, lpOutData As Any) As Integer

' GDI Escapes
Global Const NEWFRAME = 1
'Global Const ABORTDOC = 2
Global Const NEXTBAND = 3
Global Const SETCOLORTABLE = 4
Global Const GETCOLORTABLE = 5
Global Const FLUSHOUTPUT = 6
Global Const DRAFTMODE = 7
Global Const QUERYESCSUPPORT = 8
Global Const SETABORTPROC = 9
'Global Const STARTDOC = 10
'Global Const ENDDOCAPI = 11
Global Const GETPHYSPAGESIZE = 12
Global Const GETPRINTINGOFFSET = 13
Global Const GETSCALINGFACTOR = 14
Global Const MFCOMMENT = 15
Global Const GETPENWIDTH = 16
Global Const SETCOPYCOUNT = 17
Global Const SELECTPAPERSOURCE = 18
Global Const DEVICEDATA = 19
Global Const PASSTHROUGH = 19
Global Const GETTECHNOLGY = 20
Global Const GETTECHNOLOGY = 20
Global Const SETENDCAP = 21
Global Const SETLINEJOIN = 22
Global Const SETMITERLIMIT = 23
Global Const BANDINFO = 24
Global Const DRAWPATTERNRECT = 25
Global Const GETVECTORPENSIZE = 26
Global Const GETVECTORBRUSHSIZE = 27
Global Const ENABLEDUPLEX = 28
Global Const GETSETPAPERBINS = 29
Global Const GETSETPRINTORIENT = 30
Global Const ENUMPAPERBINS = 31
Global Const SETDIBSCALING = 32
Global Const EPSPRINTING = 33
Global Const ENUMPAPERMETRICS = 34
Global Const GETSETPAPERMETRICS = 35
Global Const POSTSCRIPT_DATA = 37
Global Const POSTSCRIPT_IGNORE = 38
Global Const GETEXTENDEDTEXTMETRICS = 256
Global Const GETEXTENTTABLE = 257
Global Const GETPAIRKERNTABLE = 258
Global Const GETTRACKKERNTABLE = 259
Global Const EXTTEXTOUTAPI = 512
Global Const ENABLERELATIVEWIDTHS = 768
Global Const ENABLEPAIRKERNING = 769
Global Const SETKERNTRACK = 770
Global Const SETALLJUSTVALUES = 771
Global Const SETCHARSET = 772

